#ifndef	_WIZARD_H_
#define	_WIZARD_H_


//Here we handle the buttons Next, Back, Finish by user defined code
//If want the wizard to handle those message automatically, can change the ID values
//of the buttons to specific values when build the DLL, like
//#define	ID_PREV	0x3023
//#define	ID_NEXT	0x3024
//#define	IDOK	0x3025
#define	WM_USER_PAGE_CHANGE		(WM_USER + 550)	
#define	STR_USER_TEXT			"UserText"

//base wizard page class
class	WizardPage : public PropertyPage
{
public:
	WizardPage(int nID = 0) : PropertyPage(nID){}
	EVENTS_BEGIN
		PAGE_ON_ACTIVE(OnActivatePage)		
		PAGE_ON_KILLACTIVE(OnKillActivatePage)
	EVENTS_END
	
	virtual	BOOL	OnActivatePage();	
	virtual	BOOL	OnKillActivatePage(){ return TRUE;}
	
	void	Init(TreeNode& trSettings);
	
protected:
	TreeNode	m_trSettings;	//for keep settings between pages
};

class	FirstPage : public WizardPage
{
public:
	FirstPage(int nID = 0) : WizardPage(nID){}

	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)		
		PAGE_ON_KILLACTIVE(OnKillActivatePage)
	EVENTS_END
	
	BOOL	OnInitPage(){return TRUE;}
};

class	SecondPage : public WizardPage
{
public:
	SecondPage(int nID = 0) : WizardPage(nID){}
	
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)		
		PAGE_ON_KILLACTIVE(OnKillActivatePage)
	EVENTS_END
	
	BOOL	OnInitPage(){return TRUE;}
	
	BOOL	OnKillActivatePage(); //save settings when switch to another page
};

class	ThirdPage : public WizardPage
{
public:
	ThirdPage(int nID = 0) : WizardPage(nID){}
	
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)		
		PAGE_ON_KILLACTIVE(OnKillActivatePage)
	EVENTS_END
	
	BOOL	OnInitPage(){return TRUE;}
	
	//virtual
	BOOL	OnActivatePage(); //load settings updated by previous pages.
};

class	LastPage : public WizardPage
{
public:
	LastPage(int nID = 0) : WizardPage(nID){}
	
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)		
		PAGE_ON_KILLACTIVE(OnKillActivatePage)
	EVENTS_END
	
	BOOL	OnInitPage(){return TRUE;}
};

//page holder
class	PlaceHolder : public WizardSheet
{
public:
	PlaceHolder();		
	BOOL	ActivePageChanged();
	void	InitMaps();
	TreeNode	GetSettings();
private:
	FirstPage	m_First;
	SecondPage	m_Second;
	ThirdPage	m_Third;
	LastPage	m_Last;
	Tree		m_trSettings; //to pass values & settings between pages.
};

class	OCWizardDlg : public Dialog
{
public:
	
	OCWizardDlg() : Dialog(IDD_OWIZARD_DLG, "wizard")
	{
	}
	int	DoModal(HWND hParent = NULL);	
protected:
	
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitDialog)
		ON_USER_MSG(WM_USER_PAGE_CHANGE, OnActivePageChanged);
		ON_BN_CLICKED(ID_NEXT, OnNext)
		ON_BN_CLICKED(ID_PREV, OnPrev)
		ON_BN_CLICKED(IDOK, OnFinish)
	EVENTS_END
	
	BOOL	OnInitDialog();
	
	BOOL	OnFinish(Control trl);
	
	//need to check and update button enable/disable state
	BOOL	OnActivePageChanged(UINT wParam, UINT lParam);
	
	//when click Next button
	BOOL	OnNext(Control ctrl);
	
	BOOL	OnPrev(Control ctrl);
	
protected:
	
	PlaceHolder	m_Holder;
	Button		m_btnPrev;
	Button		m_btnNext;
};


#endif	//_WIZARD_H_